
function dydt=Eff_mass_acc_model_F(t,y)
global Cgi Koai To p_i
global Db W a0 B_acc Dg T_BL
dydt=zeros(6,1);

Tt=To+y(1)/p_i+y(2)/p_i+y(3)/p_i+y(4)/p_i+y(5)/p_i+y(6)/p_i; %Total film thickness (cm)
Penetration_length=Tt/3; %Effective penetration depth (cm)
for i=1:6
    alpha_eff(i)=a0*1/(1+(a0*W(i)/(Koai(i)*4*Db))*Penetration_length); %Effective mass accommodation coefficient of SVOC group i (no units)
end

for i=1:6
    if alpha_eff(i)<=B_acc(i) %If the effective mass accommodation coefficient is smaller than the bulk accommodation coefficient
        vdi(i)=(T_BL/Dg+1/(alpha_eff(i)*W(i)./4))^(-1);% Deposition velocity of SVOC group i (cm s-1)
    else %If the bulk accommodation coefficient is smaller than the effective mass accommodation coefficient
        vdi(i)=(T_BL/Dg+1/(B_acc(i)*W(i)./4))^(-1);% Deposition velocity of SVOC group i (cm s-1)        
    end
end

for i=1:6
    Fi(i)=vdi(i)*(Cgi(i)-(y(i)/(Tt*Koai(i)))); % net flux of SVOC group i to the surface film (g cm-2 s-1)
end

%----------differential equations (g cm-2 s-1)-------------

dydt(1)=Fi(1); % SVOC group 1
dydt(2)=Fi(2); % SVOC group 2
dydt(3)=Fi(3); % SVOC group 3
dydt(4)=Fi(4); % SVOC group 4
dydt(5)=Fi(5); % SVOC group 5
dydt(6)=Fi(6); % SVOC group 6
return